package com.mmc.iuav.user.entity;

import com.mmc.iuav.user.entity.wallet.UserBillingDetailVO;
import com.mmc.iuav.user.enums.SettleTypeEnum;
import com.mmc.iuav.user.model.dto.wallet.WithdrawalApplyDTO;
import com.mmc.iuav.user.model.vo.XzWithdrawalVO;
import com.mmc.iuav.user.model.vo.wallet.ApplyWithdrawalVO;
import com.mmc.iuav.user.util.PrivacyUtil;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/8/23 16:17
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class XzWithdrawalApplyDO implements Serializable {
    private static final long serialVersionUID = 7891653696372539753L;
    private Integer id;
    private Integer userAccountId;
    private Integer applyStatus;
    private String bankName;
    private String bankRemo;
    private String empNum;
    private String empName;
    private String empPhone;
    private String licenseId;
    private String licenseType;
    private String month;
    private String notifyUrl;
    private String outerTradeNo;
    private String payAccount;
    private Double payAmount;
    private String positionName;
    private String remarks;
    private String settleType;
    private String taxFundId;
    private String wechatAppId;
    private String tradeStatus;
    private String tradeTime;
    private String frontLogNo;
    private String tradeFailCode;
    private String tradeResult;
    private String submitStatus;
    private String errorCode;
    private Date payTime;
    private String errorMessage;
    private BigDecimal chargeAmount;
    private Date createTime;
    private String remark;
    private Integer approveUser;
    private Date approveTime;


    public XzWithdrawalApplyDO(XzWithdrawalVO xzWithdrawalVO) {
        this.userAccountId = xzWithdrawalVO.getUserAccountId();
        this.notifyUrl = xzWithdrawalVO.getNotifyUrl();
        this.taxFundId = xzWithdrawalVO.getTaxFundId();
        this.month = xzWithdrawalVO.getMonth();
        this.outerTradeNo = xzWithdrawalVO.getOuterTradeNo();
        this.empName = xzWithdrawalVO.getEmpName();
        this.empPhone = xzWithdrawalVO.getEmpPhone();
        this.empNum = xzWithdrawalVO.getEmpNum();
        this.licenseId = xzWithdrawalVO.getLicenseId();
        this.licenseType = xzWithdrawalVO.getLicenseType();
        this.settleType = xzWithdrawalVO.getSettleType();
        this.payAmount = xzWithdrawalVO.getPayAmount();
        this.payAccount = xzWithdrawalVO.getSettleType().equals(SettleTypeEnum.BANK.getCode()) ?
                xzWithdrawalVO.getPayAccount() : xzWithdrawalVO.getWechatAppId();
        this.bankName = xzWithdrawalVO.getBankName();
        this.positionName = xzWithdrawalVO.getPositionName();
        this.remarks = xzWithdrawalVO.getRemarks();
        this.bankRemo = xzWithdrawalVO.getBankRemo();
    }

    public XzWithdrawalApplyDO(ApplyWithdrawalVO applyWithdrawalVO) {
        this.userAccountId = applyWithdrawalVO.getUserAccountId();
        this.bankName = applyWithdrawalVO.getBankName();
        this.settleType = applyWithdrawalVO.getSettleType();
        this.payAccount = applyWithdrawalVO.getPayAccount();
        this.positionName = applyWithdrawalVO.getPositionName();
        this.payAmount = applyWithdrawalVO.getPayAmount().doubleValue();
    }

    public UserBillingDetailVO buildUserBillingDetailVO() {
        payAccount = PrivacyUtil.encryptBankAcct(payAccount);
        String name = "提现";
        if (this.applyStatus == 0) {
            name = "平台处理中";
        } else if (this.applyStatus == 1) {
            name = "审批通过";
        } else if (this.applyStatus == 2) {
            name = "审批未通过";
        }
        return UserBillingDetailVO.builder().userAccountId(userAccountId)
                .payNo(outerTradeNo).payTime(payTime).account(payAccount)
                .name(name).id(id).build();
    }

    public WithdrawalApplyDTO buildWithdrawalApplyDTO() {
        return WithdrawalApplyDTO.builder().id(id).userAccountId(userAccountId).applyAmt(new BigDecimal(payAmount))
                .applyStatus(applyStatus).empName(empName).bankName(bankName).payAccount(payAccount)
                .remark(remark).outerTradeNo(outerTradeNo).phoneNum(empPhone).settleType(settleType)
                .tradeResult(tradeResult).createTime(createTime).build();
    }
}
