package com.mmc.iuav.user.schedule;

import com.mmc.iuav.user.model.vo.data.ActiveUserCountVO;
import com.mmc.iuav.user.service.data.UserReportService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Calendar;

/**
 * @author lw
 */
@Component
@ConditionalOnProperty(prefix = "scheduling", name = "enabled", havingValue = "true")
public class ManagerLogSchedule {
    @Resource
    UserReportService userReportService;

    /**
     * 统计日活量
     */
    @Scheduled(cron = "0 0 10 * * ?")
    public void calculateActiveUserCount() {
        Integer userActiveCount = userReportService.getUserActiveCount();

        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DAY_OF_MONTH, -1);
        //记录到数据库
        ActiveUserCountVO yxfActiveUserCountVO = new ActiveUserCountVO();
        yxfActiveUserCountVO.setActiveDate(calendar.getTime());
        yxfActiveUserCountVO.setActiveUserCount(userActiveCount);
        userReportService.insertActiveUserCount(yxfActiveUserCountVO);
    }

}