package com.mmc.iuav.user.service.impl;

import com.alibaba.fastjson2.JSONObject;
import com.github.xiaoymin.knife4j.core.util.CollectionUtils;
import com.mmc.iuav.http.BizException;
import com.mmc.iuav.page.PageResult;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.response.ResultEnum;
import com.mmc.iuav.user.dao.CompanyAuthDao;
import com.mmc.iuav.user.dao.CompanyDao;
import com.mmc.iuav.user.dao.CooperationDao;
import com.mmc.iuav.user.entity.*;
import com.mmc.iuav.user.enums.RoleEnums;
import com.mmc.iuav.user.model.dto.WebsiteRangeDTO;
import com.mmc.iuav.user.model.qo.ApplyQO;
import com.mmc.iuav.user.model.vo.*;
import com.mmc.iuav.user.service.BackUserAccountService;
import com.mmc.iuav.user.service.CooperationService;
import com.mmc.iuav.user.service.UserAccountService;
import com.mmc.iuav.user.util.SmsUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author: zj @Date: 2023/5/17 21:19
 */
@Service
@Slf4j
public class CooperationServiceImpl implements CooperationService {
    @Autowired
    private CooperationDao cooperationDao;

    @Autowired
    private CompanyAuthDao companyAuthDao;

    @Autowired
    private BackUserAccountService backUserAccountService;

    @Autowired
    private UserAccountService userAccountService;

    @Autowired
    private CompanyDao companyDao;

    @Override
    public List<CooperationTagVO> listTag() {
        List<CooperationTagDO> list = cooperationDao.listTags();
        List<CooperationTagVO> resList =
                list.stream().map(CooperationTagDO::buildCooperationTagVO).collect(Collectors.toList());
        return resList;
    }

    @Override
    public ResultBody apply(UserApplyTagVO userApplyTagVO) {
        int applyCount = cooperationDao.countUserApplyTagByUid(userApplyTagVO.getUserAccountId());
        if (applyCount > 0) {
            return ResultBody.error(ResultEnum.TAG_APPLY_ALREADY_EXIST_ERROR);
        }
        int count = cooperationDao.userTagInfo(userApplyTagVO.getCooperationTagId(), userApplyTagVO.getUserAccountId());
        if (count > 0) {
            return ResultBody.error(ResultEnum.TAG_ALREADY_EXIST_ERROR);
        }
        // 判断企业认证
        CompanyAuthDO companyAuthDO = companyAuthDao.getCompanyAuth(userApplyTagVO.getUserAccountId());
        if (companyAuthDO == null) {
            return ResultBody.error(ResultEnum.COMPANY_NOT_AUTH_ERROR);
        }
        Integer cooperationTagId = userApplyTagVO.getCooperationTagId();
        if (cooperationTagId == 1) {
            if ("".equals(userApplyTagVO.getBrandName()) || userApplyTagVO.getBrandName() == null) {
                return ResultBody.error(ResultEnum.THE_BRAND_NAME_CANNOT_BE_EMPTY);
            } else if ("".equals(userApplyTagVO.getBrandLogo()) || userApplyTagVO.getBrandLogo() == null) {
                return ResultBody.error(ResultEnum.THE_BRAND_LOGO_CANNOT_BE_EMPTY);
            }
        }

        UserApplyTagDO userApplyTagDO = new UserApplyTagDO(userApplyTagVO);
        userApplyTagDO.setCompanyInfoId(companyAuthDO.getCompanyInfoId());
        cooperationDao.addApply(userApplyTagDO);
        List<AttachmentVO> attachmentList = userApplyTagVO.getAttachmentList();
        for (AttachmentVO attachmentVO : attachmentList) {
            TagApplyResourceDO tagApplyResourceDO =
                    new TagApplyResourceDO(attachmentVO, userApplyTagDO.getId());
            cooperationDao.addApplyResource(tagApplyResourceDO);
        }

        cooperationDao.updateCompanyInfo(userApplyTagDO);
        return ResultBody.success();
    }

    @Transactional
    @Override
    public ResultBody changeUserTag(UserCooperationTagVO userCooperationTagVO) {
        // 删除原来的
        cooperationDao.removeUserTag(userCooperationTagVO.getUserAccountId());
        // 添加新的
        if (!CollectionUtils.isEmpty(userCooperationTagVO.getCooperationTagIds())) {
            cooperationDao.batchInsertUserTag(userCooperationTagVO.getUserAccountId(), userCooperationTagVO.getCooperationTagIds());
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody getTagById(Integer id) {
        CooperationTagDO cooperationTagDO = cooperationDao.getTagById(id);
        if (cooperationTagDO == null) {
            return ResultBody.success();
        }
        return ResultBody.success(cooperationTagDO.buildCooperationTagVO());
    }

    @Override
    public PageResult listUserApplyTag(ApplyQO applyQO) {
        int count = cooperationDao.countListUserApplyTag(applyQO);
        if (count == 0) {
            return PageResult.buildPage(applyQO.getPageNo(), applyQO.getPageSize(), count);
        }
        int pageNo = applyQO.getPageNo();
        applyQO.buildCurrentPage();
        List<UserApplyTagDO> userApplyTagList = cooperationDao.listUserApplyTag(applyQO);
        List<UserApplyTagVO> list =
                userApplyTagList.stream()
                        .map(UserApplyTagDO::buildUserApplyTagVO)
                        .collect(Collectors.toList());
        return PageResult.buildPage(pageNo, applyQO.getPageSize(), count, list);
    }

    @Override
    public ResultBody deleteApplyTag(Integer id) {
        cooperationDao.deleteApplyTag(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody applyTagDetails(Integer id, Integer userAccountId) {
        // 初始化返回对象
        UserApplyTagDetailsVO userApplyTagDetailsVO = new UserApplyTagDetailsVO();
        // 获取企业认证信息
        CompanyAuthDO companyAuthDO = companyAuthDao.getCompanyAuth(userAccountId);
        // 获取申请信息
        UserApplyTagDO userApplyTag = cooperationDao.getUserApplyTag(id);
        // 获取附件信息
        List<TagApplyResourceDO> tagApplyResourceList = cooperationDao.getUserApplyResource(id);
        if (CollectionUtils.isNotEmpty(tagApplyResourceList)) {
            List<AttachmentVO> list =
                    tagApplyResourceList.stream()
                            .map(TagApplyResourceDO::buildAttachmentVO)
                            .collect(Collectors.toList());
            userApplyTagDetailsVO.setAttachmentList(list);
        }
        userApplyTagDetailsVO.setCompanyName(companyAuthDO.getCompanyName());
        userApplyTagDetailsVO.setLicenseImg(companyAuthDO.getLicenseImg());
        userApplyTagDetailsVO.setCreditCode(companyAuthDO.getCreditCode());
        userApplyTagDetailsVO.setRemark(userApplyTag.getRemark());
        return ResultBody.success(userApplyTagDetailsVO);
    }

    @Transactional
    @Override
    public ResultBody approvalApplyTag(Integer id, Boolean status) {
        // 判断用户是否已经是该渠道
        UserApplyTagDO userApplyTag = cooperationDao.getUserApplyTag(id);
        int count =
                cooperationDao.userTagInfo(
                        userApplyTag.getCooperationTagId(), userApplyTag.getUserAccountId());
        UserAccountVO account = userAccountService.getUserAccountById(userApplyTag.getUserAccountId());
        if (status) {
            cooperationDao.updateApplyTagStatus(id, 1);
            if (count == 0) {
                // 审批通过往用户标签表中新增一条数据
                UserTagDO userTagDO = new UserTagDO();
                userTagDO.setUserAccountId(userApplyTag.getUserAccountId());
                userTagDO.setCooperationTagId(userApplyTag.getCooperationTagId());
                cooperationDao.insertUserTag(userTagDO);
            }
            // 审批通过生成后台对应的账号
            BUserAccountVO bUserAccountVO = this.generateBackUserAccountVO(userApplyTag);
            ResultBody resultBody = backUserAccountService.insertBAccount(bUserAccountVO);
            if (!resultBody.getCode().equals(ResultEnum.SUCCESS.getResultCode())) {
                // 生成账号失败处理
                if (resultBody.getCode().equals(ResultEnum.ADD_USER_ACCOUNT_NAME_EXISTS.getResultCode())) {
                    bUserAccountVO.setAccountNo(bUserAccountVO.getPhoneNum() + "X");
                    ResultBody retryResultBody = backUserAccountService.insertBAccount(bUserAccountVO);
                    if (retryResultBody.getCode().equals(ResultEnum.SUCCESS.getResultCode())) {
                        throw new BizException(ResultEnum.COOPERATION_CHECK_NOT_PASS_ERROR);
                    }
                }
                throw new BizException(ResultEnum.COOPERATION_CHECK_NOT_PASS_ERROR);
            }
            log.info("check apply cooperation tag, bUserAccountVO:{}", JSONObject.toJSONString(bUserAccountVO));
            Map<String, String> param = new HashMap<String, String>();
            param.put("accountNo", bUserAccountVO.getAccountNo());
            param.put("password", bUserAccountVO.getPassWord());
            SmsUtil.sendPassCooperationApply(JSONObject.toJSONString(param), bUserAccountVO.getPhoneNum());
        } else {
            SmsUtil.sendNotPassCooperationApply(account.getPhoneNum());
            cooperationDao.updateApplyTagStatus(id, 2);
        }
        return ResultBody.success();
    }

    private BUserAccountVO generateBackUserAccountVO(UserApplyTagDO userApplyTagDO) {
        BUserAccountVO bUserAccountVO = new BUserAccountVO();
        UserAccountVO userAccountVO = userAccountService.getUserAccountById(userApplyTagDO.getUserAccountId());
        bUserAccountVO.setAccountNo(userAccountVO.getPhoneNum());
        bUserAccountVO.setUserName(userApplyTagDO.getApplyName());
        bUserAccountVO.setPhoneNum(userAccountVO.getPhoneNum());
        String password = RandomStringUtils.randomAlphanumeric(8);
        bUserAccountVO.setPassWord(password);
        bUserAccountVO.setAlertPwd(password);
        bUserAccountVO.setAccountStatus(1);
        bUserAccountVO.setRoleId(RoleEnums.FRANCHISEE.getId());
        // 添加单位id
        CompanyInfoDO companyInfo = this.getCompanyInfo(userApplyTagDO);
        bUserAccountVO.setCompanyId(companyInfo.getId());
        bUserAccountVO.setRemark("加盟商自动生成");
        return bUserAccountVO;
    }

    private CompanyInfoDO getCompanyInfo(UserApplyTagDO userApplyTagDO) {
        // 查询小程序用户认证单位信息
        CompanyAuthDO companyAuth = companyAuthDao.getCompanyAuth(userApplyTagDO.getUserAccountId());
        // 验证是否已经添加单位信息
        CompanyInfoDO existCompanyInfo = companyDao.getCompanyInfoByName(companyAuth.getCompanyName());
        // 添加单位信息
        if (existCompanyInfo == null) {
            CompanyInfoDO companyInfoDO = new CompanyInfoDO();
            companyInfoDO.setCompanyType(1);
            companyInfoDO.setCompanyName(companyAuth.getCompanyName());
            companyInfoDO.setFullName(companyAuth.getCompanyName());
            companyInfoDO.setCompanyUserName(userApplyTagDO.getApplyName());
            companyInfoDO.setPhoneNum(userApplyTagDO.getApplyPhone());
            companyDao.addCompanyInfo(companyInfoDO);
            return companyInfoDO;
        } else {
            return existCompanyInfo;
        }
    }

    @Override
    public ResultBody editUserApplyTag(ApplyTagEditVO applyTagEditVO) {
        //判断当前服务商是否通过审核
        UserApplyTagDO userApplyTag = cooperationDao.getUserApplyTag(applyTagEditVO.getId());
        if (!userApplyTag.getApplyStatus().equals(1)) {
            return ResultBody.error("当前服务商暂未通过审核！");
        }
        // 编辑服务商信息
        UserApplyTagDO userApplyTagDO = new UserApplyTagDO();
        userApplyTagDO.setId(applyTagEditVO.getId());
        userApplyTagDO.setContent(applyTagEditVO.getContent());
        userApplyTagDO.setScore(applyTagEditVO.getScore());
        userApplyTagDO.setRemark(applyTagEditVO.getRemark());
        cooperationDao.updateUserApplyTag(userApplyTagDO);
        userApplyTagDO.setAttachmentList(applyTagEditVO.getAttachmentList());
        List<AttachmentVO> attachmentList = userApplyTagDO.getAttachmentList();

        if (null != attachmentList) {
            cooperationDao.deleteApplyResource(applyTagEditVO.getId());
            if (attachmentList.size() != 0) {
                cooperationDao.insertApplyResource(userApplyTagDO.getAttachmentList());
            }
        }
        // 保存网点之前判断该网点是否存在 存在则修改不存在则新增
        WebsiteInfoDO websiteInfoDO = cooperationDao.getWebsiteInfoByUserApplyId(applyTagEditVO.getId());
        if (websiteInfoDO == null) {
            // 保存网点信息
            cooperationDao.addWebsiteInfo(applyTagEditVO);
        } else {
            applyTagEditVO.setWebsiteId(websiteInfoDO.getId());
            // 修改网点信息
            cooperationDao.updateWebsiteInfo(applyTagEditVO);
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody editUserApplyTagDetails(Integer id) {
        UserApplyTagDO userApplyTag = cooperationDao.getUserApplyTag(id);
        return ResultBody.success(userApplyTag == null ? null : userApplyTag.buildApplyTagEditVO());
    }

    @Override
    public PageResult listServiceBitmapData(Integer type, Integer pageNo, Integer pageSize, Double lon, Double lat) {
        int count = cooperationDao.countServiceBitmapData(type);
        if (count == 0) {
            return PageResult.buildPage(pageNo, pageSize, count);
        }
        List<WebsiteRangeDTO> list = cooperationDao.listServiceBitmapData(type, lon, lat, (pageNo - 1) * pageSize, pageSize)
                .stream().map(WebsiteInfoDO::buildWebsiteRangeDTO).collect(Collectors.toList());
        return PageResult.buildPage(pageNo, pageSize, count, list);
    }

    @Override
    public ResultBody appBrandList() {
        List<CompanyInfoDO> companyInfoDOS = cooperationDao.appBrandList();
        List<CompanyInfoVO> collect = companyInfoDOS.stream().map(CompanyInfoDO::buildCompanyInfoVO).collect(Collectors.toList());
        return ResultBody.success(collect);
    }
}
