package com.mmc.iuav.user.controller.wallet;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.controller.BaseController;
import com.mmc.iuav.user.entity.wallet.UserBillingDetailVO;
import com.mmc.iuav.user.model.dto.wallet.PayWalletDTO;
import com.mmc.iuav.user.model.qo.wallet.WalletFlowQO;
import com.mmc.iuav.user.model.vo.wallet.PayUavWalletVO;
import com.mmc.iuav.user.model.vo.wallet.TopUpOrderVO;
import com.mmc.iuav.user.model.vo.wallet.WalletFlowVO;
import com.mmc.iuav.user.service.wallet.PayWalletService;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * @Author LW
 * @date 2023/8/18 11:33
 * 概要：
 */
@Api(tags = "V1.0.3-用户钱包-相关接口")
@RequestMapping("/pay/")
@RestController
public class PayWalletController extends BaseController {

    @Resource
    PayWalletService payWalletService;

    @ApiOperation(value = "获取当前用户消费(钱包)信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PayWalletDTO.class)})
    @GetMapping("getCurrentUserPayWalletInfo")
    public ResultBody<PayWalletDTO> getCurrentUserPayWalletInfo(HttpServletRequest request) {
        return payWalletService.getPayWalletInfo(this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "获取用户消费(钱包)信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PayWalletDTO.class)})
    @GetMapping("getPayWalletInfo")
    public ResultBody<PayWalletDTO> getPayWalletInfo(
            @ApiParam(value = "用户userAccountId", required = true) @RequestParam Integer userAccountId) {
        return payWalletService.getPayWalletInfo(userAccountId);
    }

    @ApiOperation(value = "feign-云享金充值增加金额")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("feignTopUpCash")
    public ResultBody feignTopUpCash(@RequestBody TopUpOrderVO topUpOrderVO) {
        return payWalletService.feignTopUpCash(topUpOrderVO);
    }

    @ApiOperation(value = "feign-钱包流水记录")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("feignWalletFlow")
    public ResultBody feignWalletFlow(@RequestBody WalletFlowVO walletFlowVO) {
        return payWalletService.feignWalletFlow(walletFlowVO);
    }

    @ApiOperation(value = "feign - 钱包流水记录（优化版）")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("optimizeWalletFlow")
    @ApiIgnore
    public ResultBody optimizeWalletFlow(@RequestBody WalletFlowVO walletFlowVO) {
        return payWalletService.optimizeWalletFlow(walletFlowVO);
    }

    @ApiOperation(value = "feign-钱包流水记录不带token")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("feignWalletFlowNO")
    public ResultBody feignWalletFlowNO(@RequestBody WalletFlowVO walletFlowVO) {
        return payWalletService.feignWalletFlow(walletFlowVO);
    }

    @ApiOperation(value = "用户账单明细")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UserBillingDetailVO.class)})
    @PostMapping("customerBillingDetail")
    public ResultBody<UserBillingDetailVO> customerBillingDetail(HttpServletRequest request, @RequestBody WalletFlowQO walletFlowQO) {
        return payWalletService.customerBillingDetail(this.getUserLoginInfoFromRedis(request).getUserAccountId(), walletFlowQO);
    }

    @ApiOperation(value = "账单详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UserBillingDetailVO.class)})
    @GetMapping("billingDetails")
    public ResultBody<UserBillingDetailVO> billingDetails(@ApiParam(value = "ID", required = true) @RequestParam Integer id,
                                                          @ApiParam(value = "详情类型", required = true) @RequestParam String detailType) {
        return payWalletService.billingDetails(id, detailType);
    }

    @ApiOperation(value = "商城订单钱包流水加扣记录")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("feignPayUavWallet")
    public ResultBody payUavWallet(@RequestBody PayUavWalletVO payUavWalletVO) {
        return payWalletService.payUavWallet(payUavWalletVO);
    }
}
