package com.mmc.iuav.user.model.fdd.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author LW
 * @date 2022/9/5 14:40
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ContractVO implements Serializable {
    private static final long serialVersionUID = 570570471824495498L;
    @ApiModelProperty(value = "合同地址")
    @NotNull(message = "合同地址不能为空")
    private String docUrl;

    @ApiModelProperty(value = "订单编号")
    @NotNull(message = "订单编号不能为空")
    private String orderNo;

    @ApiModelProperty(value = "合同标题")
    @NotNull(message = "合同标题不能为空")
    private String title;
}
