package com.mmc.iuav.user.service.data.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.dao.CooperationDao;
import com.mmc.iuav.user.dao.RealNameAuthDao;
import com.mmc.iuav.user.dao.UserServiceDao;
import com.mmc.iuav.user.dao.dronepilot.PilotCertificationDao;
import com.mmc.iuav.user.entity.data.ActiveUserCountDO;
import com.mmc.iuav.user.model.dto.data.ProductReportDTO;
import com.mmc.iuav.user.model.dto.data.UserReportDTO;
import com.mmc.iuav.user.model.vo.data.ActiveUserCountVO;
import com.mmc.iuav.user.service.WxService;
import com.mmc.iuav.user.service.data.UserReportService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @Author LW
 * @date 2023/9/16 13:24
 * 概要：
 */
@Service
public class UserReportServiceImpl implements UserReportService {
    @Resource
    private UserServiceDao userServiceDao;
    @Resource
    private RealNameAuthDao realNameAuthDao;
    @Resource
    private PilotCertificationDao pilotCertificationDao;
    @Resource
    private WxService wxService;
    @Resource
    private CooperationDao cooperationDao;

    @Override
    public ResultBody<UserReportDTO> getUserReportData(String date) {
        UserReportDTO userReportDTO = new UserReportDTO();
        // 获取可用用户总数
        int userCount = userServiceDao.getUsableUserCount();
        userReportDTO.setUserCount(userCount);
        // 获取实名认证用户数量
        int realNameCount = realNameAuthDao.getRealNameAuthCount();
        userReportDTO.setRealNameCount(realNameCount);
        // 获取飞手认证用户数量
        int dronePilotCount = pilotCertificationDao.getDronePilotCount();
        userReportDTO.setDronePilotCount(dronePilotCount);
        // 获取昨日新增用户数
        int yesterdayUserCount = userServiceDao.getYesterdayAddUserCount();
        userReportDTO.setYesterdayAddUserCount(yesterdayUserCount);
        // 获取昨日活跃用户数
        ActiveUserCountDO activeUserCountByDayNum = userServiceDao.getActiveUserCountByDayNum();
        userReportDTO.setYesterdayActiveUserCount(activeUserCountByDayNum.getActiveUserCount());
        return ResultBody.success(userReportDTO);
    }

    @Override
    public Integer getUserActiveCount() {
        ResultBody resultBody = wxService.getUserPortrait();
        if (resultBody != null && "200".equals(resultBody.getCode())) {
            JSONObject result = JSONObject.parseObject(resultBody.getResult().toString());
            JSONArray jsonArray;
            //当去微信拿不到日活量时会报空指针就返回null代表没拿到数据，要重新请求
            try {
                jsonArray = JSONArray.parseArray(result.get("list").toString());
            }catch (NullPointerException e) {
                return null;
            }
            JSONObject object = (JSONObject) jsonArray.get(0);
            return (Integer) object.get("visit_uv");
        }
        return 0;
    }

    @Override
    public int  insertActiveUserCount(ActiveUserCountVO param) {
        ActiveUserCountDO activeUserCountDO = new ActiveUserCountDO(param);
        return userServiceDao.insertActiveUserCount(activeUserCountDO);
    }

    @Override
    public ProductReportDTO getJoinStoreNumber() {
        ProductReportDTO productReportDTO = new ProductReportDTO();
        // 获取企业认证总数
        int companyAuthCount = userServiceDao.appUserCompanyAuthCount();
        productReportDTO.setCompanyAuthCount(companyAuthCount);
        // 获取入驻商家数量
        int joinStoreCount = cooperationDao.getJoinStoreCount();
        productReportDTO.setJoinStoreCount(joinStoreCount);
        // 获取品牌商入驻数量
        productReportDTO.setBrandStore(cooperationDao.getStoreCountByType(1));
        // 获取维修商数量
        productReportDTO.setRepairStore(cooperationDao.getStoreCountByType(10));
        // 获取培训机构数量
        productReportDTO.setTrainingInstitution(cooperationDao.getStoreCountByType(4));
        // 获取租赁商数量
        productReportDTO.setLeaseStore(cooperationDao.getStoreCountByType(3));
        // 获取服务商数量
        productReportDTO.setServiceStore(cooperationDao.getStoreCountByType(5));
        return productReportDTO;
    }
}
