package com.mmc.iuav.user.mq;

import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author: zj
 * @Date: 2023/6/26 17:43
 */
@Configuration
public class FanoutExchangeConfig {
    @Bean
    public FanoutExchange fanoutExchange(){
        return new FanoutExchange(RabbitmqConstant.USER_INFO_UPDATE_FANOUT_EXCHANGE);
    }

    @Bean
    public Queue fanoutQueue1() {
        return new Queue(RabbitmqConstant.USER_INFO_UPDATE_FANOUT_FORUM_QUEUE, true);
    }

    @Bean
    public Binding bindingFanout1() {
        Binding binding = BindingBuilder.bind(fanoutQueue1()).to(fanoutExchange());
        return binding;
    }

}
