package com.mmc.iuav.user.service;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.entity.BackUserAccountDO;
import com.mmc.iuav.user.entity.BackUserSuggestionDO;
import com.mmc.iuav.user.model.dto.LoginSuccessDTO;
import com.mmc.iuav.user.model.qo.BUserAccountQO;
import com.mmc.iuav.user.model.vo.BUserAccountVO;
import com.mmc.iuav.user.model.vo.BackUserAccountVO;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/6/21 15:48
 */
public interface BackUserAccountService {
    /**
     * 添加后台用户
     *
     * @param bUserAccountVO
     * @param loginSuccessDTO
     * @return
     */
    ResultBody insertBAccount(BUserAccountVO bUserAccountVO, LoginSuccessDTO loginSuccessDTO);

    /**
     * 添加后台用户信息
     *
     * @param bUserAccountVO
     * @param loginSuccessDTO
     * @return
     */
    ResultBody updateBAccount(BUserAccountVO bUserAccountVO, LoginSuccessDTO loginSuccessDTO);

    /**
     * 禁用后台用户
     *
     * @param accountId
     * @param loginSuccessDTO
     * @return
     */
    ResultBody disableBAccount(Integer accountId, LoginSuccessDTO loginSuccessDTO);

    /**
     * 后台用户列表
     *
     * @param bUserAccountQO
     * @param loginSuccessDTO
     * @return
     */
    ResultBody<BackUserAccountVO> listBAccountPage(BUserAccountQO bUserAccountQO, LoginSuccessDTO loginSuccessDTO);

    /**
     * 内部远程调用查询用户信息
     *
     * @param bUserAccountQO
     * @return
     */
    List<BackUserAccountVO> feignListBAccountPage(BUserAccountQO bUserAccountQO);

    /**
     * 修改用户密码
     *
     * @param account
     * @param loginSuccessDTO
     * @return
     */
    ResultBody updatePassword(BUserAccountVO account, LoginSuccessDTO loginSuccessDTO);

    /**
     * 内部确认用户密码
     *
     * @param id
     * @param authPwd
     * @return
     */
    ResultBody feignAuthUserPwd(Integer id, String authPwd);

    /**
     * 登录账号密码查询用户信息
     *
     * @param accountNo
     * @param passWord
     * @return
     */
    BackUserAccountDO getUserLoginInfo(String accountNo, String passWord);

    /**
     * 获取后台用户信息
     *
     * @param backUserAccountId
     * @return
     */
    BackUserAccountVO getBackUserAccountById(Integer backUserAccountId);


    /**
     * 获取后台新消息
     * @return {@link ResultBody}
     */
    ResultBody getMessage();

    ResultBody insertCompanySuggestion(BackUserSuggestionDO backUserSuggestionDO,Integer backUserId);


    ResultBody getSuggestion(Integer backUserId);
}
