package com.mmc.iuav.user.model.qo.dronepilot;

import com.mmc.iuav.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;

/**
 * @Author small
 * @Date 2023/7/29 16:42
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PilotAuditStatusQO {

    @ApiModelProperty(value = "飞手认证id", required = true)
    @NotNull(message = "审批是不能为空不能为空", groups = {Update.class})
    private Integer id;


    @ApiModelProperty(value = "0审核中 1审核通过 2审核不通过", required = false, example = "0")
    private Integer auditStatus;


    @ApiModelProperty(value = "2不通过的原因", required = false, example = "信息不完善")
    private String reason;

    @ApiModelProperty(value = "审批人", required = false, example = "信息不完善", hidden = true)
    private Integer operatorUserId;

}
