package com.mmc.iuav.user.entity.wallet;

import java.io.Serializable;
import java.util.Date;

/**
 * 现金流水表(PayLogDO)实体类
 *
 * @author makejava
 * @since 2023-08-18 16:18:01
 */
public class PayLogDO implements Serializable {
    private static final long serialVersionUID = 752682324297846133L;

    private Integer id;
    /**
     * 支付人的userId
     */
    private Integer userAccountId;
    /**
     * 订单编号
     */
    private Integer orderNo;
    /**
     * 支付流水号(T202109031615XXXX)XXXX随机数
     */
    private String payNo;
    /**
     * 0手动变更(大于0充值or小于0扣除) 100订单扣除 150订单冻结  200订单完成  250提现扣除
     */
    private Integer payMethod;
    /**
     * 云享金变动金额(正数充值，负数扣除)
     */
    private Double cashAmtPaid;
    /**
     * 佣金变动金额(正数入账，负数扣除)
     */
    private Double salaryAmtPaid;
    /**
     * 支付时间
     */
    private Date payTime;
    /**
     * 备注
     */
    private String remark;
    /**
     * 操作用户id
     */
    private Integer operateUser;

    private Date createTime;

    private Date updateTime;


    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getUserAccountId() {
        return userAccountId;
    }

    public void setUserAccountId(Integer userAccountId) {
        this.userAccountId = userAccountId;
    }

    public Integer getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(Integer orderNo) {
        this.orderNo = orderNo;
    }

    public String getPayNo() {
        return payNo;
    }

    public void setPayNo(String payNo) {
        this.payNo = payNo;
    }

    public Integer getPayMethod() {
        return payMethod;
    }

    public void setPayMethod(Integer payMethod) {
        this.payMethod = payMethod;
    }

    public Double getCashAmtPaid() {
        return cashAmtPaid;
    }

    public void setCashAmtPaid(Double cashAmtPaid) {
        this.cashAmtPaid = cashAmtPaid;
    }

    public Double getSalaryAmtPaid() {
        return salaryAmtPaid;
    }

    public void setSalaryAmtPaid(Double salaryAmtPaid) {
        this.salaryAmtPaid = salaryAmtPaid;
    }

    public Date getPayTime() {
        return payTime;
    }

    public void setPayTime(Date payTime) {
        this.payTime = payTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getOperateUser() {
        return operateUser;
    }

    public void setOperateUser(Integer operateUser) {
        this.operateUser = operateUser;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

}

