package com.mmc.iuav.user.entity.signin;

import com.mmc.iuav.user.model.dto.signin.SignInDTO;
import com.mmc.iuav.user.model.vo.signin.SignInVO;
import com.mmc.iuav.user.model.vo.signin.UserContinuousCheckInVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import java.util.List;

/**
 * @Author small
 * @Date 2023/10/13 9:51
 * @Version 1.0
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class SignInDO {

    @ApiModelProperty(value = "id")
    private Integer id;

    @ApiModelProperty(value = "是否启用",example = "true 启用 false 不启用")
    private Boolean status;

    @ApiModelProperty(value = "签到周期",example = "7")
    @Min(value = 7,message = "最小是7")
    private Integer period;

    @ApiModelProperty(value = "每日签到赠送奖励积分",example = "5")
    private Integer integral;

    @ApiModelProperty(value = "连续签到信息")
    private List<UserContinuousCheckInVO> userContinuousCheckInVO;


    public SignInDO(SignInVO signInVO){
        this.id=signInVO.getId();
        this.status=signInVO.getStatus();
        this.period= signInVO.getPeriod();
        this.integral= signInVO.getIntegral();
        this.userContinuousCheckInVO=signInVO.getUserContinuousCheckInVO();
    }

    public SignInDTO buildSignInDTO(){
        return SignInDTO.builder()
                .id(this.id)
                .integral(this.integral)
                .period(this.period)
                .status(this.status)
                .userContinuousCheckInVO(userContinuousCheckInVO)
                .build();
    }
}
