package com.mmc.iuav.user.model.dto.dronepilot;

import com.alibaba.fastjson2.annotation.JSONField;
import com.mmc.iuav.group.Create;
import com.mmc.iuav.group.Update;
import com.mmc.iuav.user.model.vo.dronepilot.EnumValue;
import com.mmc.iuav.user.model.vo.dronepilot.PilotAbilityVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.Date;
import java.util.List;

/**
 * @Author small
 * @Date 2023/7/28 10:02
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PilotCertificationDTO {
    @ApiModelProperty(value = "飞手执照id", example = "1")
    @NotNull(message = "飞手执照id不能为空", groups = Update.class)
    private Integer id;


    @ApiModelProperty(value = "执照类型 CAAC,UTC,OTHER(其他) 目前只有三种", example = "UTC", required = false)
    @EnumValue(enumClass = LicenseType.class, message = "取值不合法,参考:LicenseType")
    private String licenseType;


    @ApiModelProperty(value = "电子执照的编号", example = "231321312313211", required = true)
    @NotBlank(message = "电子执照的编号不能为空", groups = {Create.class, Update.class})
    private String licenseNumber;

    @ApiModelProperty(value = "上传执照", example = "http://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/2cbbeffb-c1d1-4b26-a9a9-9e17c85e35a9.jpg", required = true)
    @NotBlank(message = "上传执照的照片不能为空", groups = {Create.class, Update.class})
    private String licenseUrl;

    @ApiModelProperty(value = "地区编号不能为空", example = "100001", required = true)
    @NotBlank(message = "地区编号不能为空", groups = {Create.class, Update.class})
    private Integer areaNumber;

    @ApiModelProperty(value = "常驻城市不能为空", example = "深圳市", required = true)
    @NotBlank(message = "常驻城市不能为空", groups = {Create.class, Update.class})
    private String residentCity;

    @ApiModelProperty(value = "工作年限", example = "3", required = true)
    @NotBlank(message = "工作年限不能为空", groups = {Create.class, Update.class})
    private Integer yearsOfWorking;


    @NotNull(message = "能力不能为空", groups = {Create.class, Update.class})
    List<PilotAbilityVO> pilotAbility;

    @ApiModelProperty(value = "能力不能为空", example = "http://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/2cbbeffb-c1d1-4b26-a9a9-9e17c85e35a9.jpg", required = true)
    @NotBlank(message = "能力图片不能为空", groups = {Create.class, Update.class})
    private String abilityUrl;

    @ApiModelProperty(value = "个人简介", example = "无人机专业，工作三年", required = true)
    @NotBlank(message = "个人简介不能为空", groups = {Create.class, Update.class})
    @Size(max = 300, message = "个人不能超过300")
    private String individualResume;

    @ApiModelProperty(value = "飞手是否同意加入飞手团队 0未操作 1飞手同意 2飞手不同意", example = "0审核中 1审核通过 2审核不通过", required = false)
    private Integer pilotStatus;

    @ApiModelProperty(value = "备注", example = "航拍摄影,农业植保", required = false)
    private String remark;

    @ApiModelProperty(value = "审核是否通过 0审核中 1审核通过 2审核不通过", example = "0审核中 1审核通过 2审核不通过", required = false)
    private Integer auditStatus;

    @ApiModelProperty(value = "申请用户的id", example = "1")
    private Integer userAccountId;

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date timeOfApplication;

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
    @ApiModelProperty(value = "申请用户的名称", example = "1")
    private String userName;
    @ApiModelProperty(value = "申请用户的性别", example = "1")
    private Integer sex;
    @ApiModelProperty(value = "申请用户的年龄", example = "1")
    private Integer age;
    /**
     * 申请飞手的手机号
     */
    @ApiModelProperty(value = "申请飞手的手机号", example = "18921312312")
    private String phoneNum;
    @ApiModelProperty(value = "审批不通过原因id", example = "1")
    private Integer reasonId;
    @ApiModelProperty(value = "审批不通过的原因", example = "1")
    private String reason;
    @ApiModelProperty(value = "飞手头像", example = "http://")
    private String userImg;
    @ApiModelProperty(value = "关注状态")
    private Boolean status;
}
